# Login Issue Troubleshooting Guide

## ⚠️ "Invalid username or password" Error - FIXED!

If you're getting "Invalid username or password" error, here are **3 solutions**:

---

## 🔧 Solution 1: Use the Create Admin Script (EASIEST)

1. Upload all files to your server
2. Visit: `http://yourdomain.com/payment_gateway/create-Creatorschoice.php`
3. Click "Create / Reset Admin User" button
4. Login with:
   - Username: `Creatorschoice`
   - Password: `Creators@7620`
5. **DELETE** `create-Creatorschoice.php` after success

---

## 🔧 Solution 2: Re-import Updated Database

The password hash has been **FIXED** in the latest `database.sql` file.

1. **Drop and recreate your database:**
   ```sql
   DROP DATABASE IF EXISTS payment_gateway;
   CREATE DATABASE payment_gateway CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
   ```

2. **Import the fixed database.sql:**
   ```bash
   mysql -u your_username -p payment_gateway < database.sql
   ```
   Or use phpMyAdmin to import `database.sql`

3. **Login with:**
   - Username: `Creatorschoice`
   - Password: `Creators@7620`

---

## 🔧 Solution 3: Reset Password Manually

If you already have data and don't want to re-import:

1. Upload `reset-Creatorschoice-password.php` to your server
2. Visit: `http://yourdomain.com/payment_gateway/reset-Creatorschoice-password.php`
3. Enter:
   - Username: `Creatorschoice`
   - New Password: (your choice)
   - Confirm Password: (repeat)
4. Click "Reset Password"
5. **DELETE** `reset-Creatorschoice-password.php` after success
6. Login with your new password

---

## 🔧 Solution 4: Direct Database Update

If you have phpMyAdmin or database access:

1. Open phpMyAdmin
2. Select `payment_gateway` database
3. Go to `Creatorschoice_users` table
4. Find the `Creatorschoice` user
5. Click "Edit"
6. Change the `password` field to:
   ```
   $2y$10$YJGZLQXup3xyzjZTQk6wMOiNvEqbLKmK8QqvqvCWxqCl8.4YiZ8iu
   ```
7. Click "Save"
8. Login with:
   - Username: `Creatorschoice`
   - Password: `Creators@7620`

---

## 📋 What Was Wrong?

The original `database.sql` had an **incorrect password hash**. The hash didn't match `Creators@7620`.

**This has been FIXED in the updated files!**

---

## ✅ Default Credentials (After Fix)

- **Username:** `Creatorschoice`
- **Password:** `Creators@7620`

⚠️ **IMPORTANT:** Change this password immediately after first login!

---

## 🆘 Still Having Issues?

### Check these common problems:

1. **Database not imported:**
   - Import `database.sql` first
   - Check if tables exist in your database

2. **Wrong database credentials:**
   - Verify settings in `config.php`
   - Test database connection

3. **Case sensitivity:**
   - Username: `Creatorschoice` (lowercase)
   - Password: `Creators@7620` (capital A, capital @)

4. **Browser cache:**
   - Clear browser cache and cookies
   - Try incognito/private browsing mode

5. **Session issues:**
   - Check PHP session directory is writable
   - Verify session settings in `php.ini`

---

## 📁 Utility Files Included

The updated package includes these helper files:

1. **create-Creatorschoice.php** - Creates/resets Creatorschoice user
2. **reset-Creatorschoice-password.php** - Reset any Creatorschoice password
3. **install-check.php** - Verify installation
4. **database.sql** - Database schema with CORRECT password

⚠️ **Delete utility files after use for security!**

---

## 🔐 After Successful Login

1. Go to your profile/settings
2. **Change your password immediately**
3. Update your email address
4. Set a strong, unique password
5. Delete all utility scripts:
   - `create-Creatorschoice.php`
   - `reset-Creatorschoice-password.php`
   - `install-check.php`

---

## 💡 Prevention for Next Time

- Always use the latest `database.sql` file
- Test login immediately after installation
- Use utility scripts if there are issues
- Keep backup of working configuration

---

## Need More Help?

1. Check `README.md` for full documentation
2. Review `QUICK_SETUP.md` for setup steps
3. Check error logs in `logs/error.log`
4. Verify PHP version (7.4+ required)
5. Check MySQL version (5.7+ required)

---

**The password issue has been FIXED in the updated files!** ✅
