# QUICK SETUP GUIDE
## International Payment Gateway System

### 🚀 Quick Start (5 Minutes)

#### Step 1: Upload Files
Upload all files to your web server (e.g., `/public_html/payment_gateway/`)

#### Step 2: Create Database
```sql
CREATE DATABASE payment_gateway CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
```

#### Step 3: Import Database
```bash
mysql -u your_username -p payment_gateway < database.sql
```
Or use phpMyAdmin to import `database.sql`

#### Step 4: Configure System
Edit `config.php`:

```php
// Database
define('DB_HOST', 'localhost');
define('DB_NAME', 'payment_gateway');
define('DB_USER', 'your_db_username');
define('DB_PASS', 'your_db_password');

// Generate encryption key (run in terminal):
// php -r "echo base64_encode(random_bytes(32));"
define('ENCRYPTION_KEY', 'PASTE_YOUR_GENERATED_KEY_HERE');

// Your site URL
define('SITE_URL', 'https://yourdomain.com/payment_gateway');

// Stripe Keys (get from https://dashboard.stripe.com/apikeys)
define('STRIPE_PUBLISHABLE_KEY', 'pk_test_YOUR_KEY');
define('STRIPE_SECRET_KEY', 'sk_test_YOUR_KEY');
```

#### Step 5: Set Permissions
```bash
chmod 755 payment_gateway/
chmod 755 payment_gateway/admin/
chmod 755 payment_gateway/classes/
chmod 755 payment_gateway/logs/
chmod 644 payment_gateway/config.php
```

#### Step 6: Verify Installation
Visit: `https://yourdomain.com/payment_gateway/install-check.php`
- Check all requirements are met
- Delete `install-check.php` when done

#### Step 7: Login to Admin Panel
Visit: `https://yourdomain.com/payment_gateway/admin/login.php`
- Username: `Creatorschoice`
- Password: `Creators@7620`
- **CHANGE PASSWORD IMMEDIATELY!**

#### Step 8: Configure Gateway
1. Go to "Gateway Configurations"
2. Add your Stripe API keys
3. Set business details
4. Choose test/live mode

#### Step 9: Create Payment Link
1. Go to "Create Payment Link"
2. Enter amount, title, description
3. Copy generated link
4. Share with customers!

### 📝 Default Admin Credentials
- Username: `Creatorschoice`
- Password: `Creators@7620`

⚠️ **SECURITY WARNING:** Change this password immediately after first login!

### 🔒 Production Checklist

Before going live, ensure:
- [ ] Changed default admin password
- [ ] Set strong encryption key
- [ ] Added real Stripe live keys
- [ ] Set `ENABLE_HTTPS_ONLY` to `true`
- [ ] Set `DISPLAY_ERRORS` to `false`
- [ ] Moved `config.php` outside web root (recommended)
- [ ] Deleted `install-check.php`
- [ ] Set up SSL certificate (HTTPS)
- [ ] Configured firewall rules
- [ ] Set up regular database backups
- [ ] Tested payment flow thoroughly

### 🎯 Features Overview

**Admin Panel:**
- Dashboard with statistics
- Create unlimited payment links
- Manage configurations
- View transactions (secure, no full card data)
- Multi-currency support
- Recurring payments
- Link expiration & usage limits

**Payment Processing:**
- International card payments
- Secure Stripe integration
- PCI DSS compliant
- No card data storage
- Real-time processing
- Custom redirect URLs

**Security:**
- End-to-end encryption
- CSRF protection
- SQL injection prevention
- XSS prevention
- Rate limiting
- Session management
- Secure password hashing

### 📧 Support & Documentation

- Full documentation: See `README.md`
- Installation issues: Check `install-check.php`
- Security best practices: See README "Security Best Practices" section

### 🔧 Troubleshooting

**Database connection fails:**
- Check credentials in `config.php`
- Ensure database exists
- Verify user has permissions

**Payment processing fails:**
- Check Stripe API keys
- Verify Stripe account is active
- Check error logs in `logs/error.log`

**Admin login fails:**
- Clear browser cache
- Check database `admin_users` table
- Reset password in database if needed

### 🌐 File Structure

```
payment_gateway/
├── admin/           # Admin panel
├── classes/         # Core classes
├── logs/           # Error logs
├── config.php      # Configuration
├── database.sql    # Database schema
├── pay.php         # Payment page
└── README.md       # Full documentation
```

### 💳 Testing

Use Stripe test cards:
- Success: `4242 4242 4242 4242`
- Decline: `4000 0000 0000 0002`
- Any future date, any 3-digit CVC

### 🎉 You're Ready!

Your payment gateway is now set up and ready to accept payments worldwide!

Need help? Check the README.md for detailed documentation.
