<?php
if (!isset($auth) || !$auth->isLoggedIn()) {
    header('Location: login.php');
    exit;
}

$currentUser = $currentUser ?? $auth->getCurrentUser();
$initials = strtoupper(substr($currentUser['username'], 0, 1));
?>
<header class="admin-header">
    <div class="header-content">
        <div class="logo">
            <h2>🔐 Payment Gateway</h2>
        </div>
        
        <div class="user-menu">
            <div class="user-info">
                <div class="user-avatar"><?php echo $initials; ?></div>
                <div>
                    <div style="font-weight: 600; font-size: 14px;">
                        <?php echo Security::escape($currentUser['full_name'] ?? $currentUser['username']); ?>
                    </div>
                    <div style="font-size: 12px; color: var(--text-secondary);">
                        <?php echo ucfirst($currentUser['role']); ?>
                    </div>
                </div>
            </div>
            
            <a href="logout.php" class="btn-logout">Logout</a>
        </div>
    </div>
</header>
