<?php
// Configuration File - KEEP THIS SECURE!
// Move this file outside web root in production

define('DB_HOST', 'localhost');
define('DB_NAME', 'payment_gateway');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_CHARSET', 'utf8mb4');

// Security Settings
define('ENCRYPTION_KEY', 'CHANGE_THIS_TO_RANDOM_32_CHAR_KEY!!'); // Generate with: openssl rand -base64 32
define('SESSION_LIFETIME', 3600); // 1 hour
define('MAX_LOGIN_ATTEMPTS', 5);
define('LOCKOUT_TIME', 900); // 15 minutes

// Application Settings
define('SITE_URL', 'http://localhost/payment_gateway');
define('ADMIN_URL', SITE_URL . '/admin');
define('API_URL', SITE_URL . '/api');

// Payment Gateway Settings
define('STRIPE_PUBLISHABLE_KEY', 'pk_test_YOUR_KEY_HERE');
define('STRIPE_SECRET_KEY', 'sk_test_YOUR_SECRET_HERE');
define('STRIPE_WEBHOOK_SECRET', 'whsec_YOUR_WEBHOOK_SECRET');

// Security Headers
define('ENABLE_HTTPS_ONLY', false); // Set to true in production
define('ENABLE_CSRF_PROTECTION', true);
define('ENABLE_RATE_LIMITING', true);

// Allowed Origins for CORS (if needed)
define('ALLOWED_ORIGINS', ['https://yourdomain.com']);

// Error Reporting
define('DISPLAY_ERRORS', true); // Set to false in production
define('LOG_ERRORS', true);
define('ERROR_LOG_PATH', __DIR__ . '/logs/error.log');

// Time Zone
date_default_timezone_set('UTC');

// Session Configuration
ini_set('session.cookie_httponly', 1);
ini_set('session.use_only_cookies', 1);
ini_set('session.cookie_secure', ENABLE_HTTPS_ONLY ? 1 : 0);
ini_set('session.cookie_samesite', 'Strict');

// Error Handling
if (DISPLAY_ERRORS) {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
} else {
    error_reporting(0);
    ini_set('display_errors', 0);
}

// Autoload function
spl_autoload_register(function ($class) {
    $file = __DIR__ . '/classes/' . str_replace('\\', '/', $class) . '.php';
    if (file_exists($file)) {
        require_once $file;
    }
});
