<?php
/**
 * Create Admin User Script
 * 
 * This script creates the default admin user with correct credentials.
 * Run this if:
 * - You're having login issues
 * - You forgot to import database.sql
 * - The admin user doesn't exist
 * 
 * SECURITY: Delete this file after creating admin user!
 */

require_once 'config.php';
require_once 'classes/Database.php';

$message = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $db = Database::getInstance();
        
        // Check if admin user already exists
        $existing = $db->fetchOne("SELECT id FROM admin_users WHERE username = 'Creatorschoice'");
        
        if ($existing) {
            // Update existing admin user
            $hashedPassword = password_hash('Creators@7620', PASSWORD_BCRYPT, ['cost' => 10]);
            
            $db->update(
                'admin_users',
                [
                    'password' => $hashedPassword,
                    'is_active' => 1
                ],
                'username = ?',
                ['Creatorschoice']
            );
            
            $message = "Admin user updated successfully!";
        } else {
            // Create new admin user
            $hashedPassword = password_hash('Creators@7620', PASSWORD_BCRYPT, ['cost' => 10]);
            
            $db->insert('admin_users', [
                'username' => 'Creatorschoice',
                'password' => $hashedPassword,
                'email' => 'admin@gateway.local',
                'full_name' => 'System Administrator',
                'role' => 'super_admin',
                'is_active' => 1
            ]);
            
            $message = "Admin user created successfully!";
        }
        
    } catch (Exception $e) {
        $error = "Error: " . $e->getMessage();
        
        // Check if tables exist
        try {
            $tables = $db->getConnection()->query("SHOW TABLES LIKE 'admin_users'")->fetch();
            if (!$tables) {
                $error = "Database tables not found. Please import database.sql first!";
            }
        } catch (Exception $e2) {
            $error = "Database connection error. Please check your config.php settings.";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create Admin User - Payment Gateway</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .container {
            background: white;
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);
            width: 100%;
            max-width: 500px;
        }
        
        h1 {
            color: #667eea;
            font-size: 28px;
            margin-bottom: 10px;
            text-align: center;
        }
        
        .subtitle {
            text-align: center;
            color: #666;
            margin-bottom: 30px;
            font-size: 14px;
        }
        
        .warning {
            background: #fef3c7;
            border-left: 4px solid #f59e0b;
            padding: 15px;
            margin-bottom: 25px;
            border-radius: 5px;
            font-size: 13px;
            color: #92400e;
        }
        
        .warning strong {
            display: block;
            margin-bottom: 5px;
        }
        
        .success-message {
            background: #d1fae5;
            color: #065f46;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            font-size: 14px;
            border-left: 4px solid #10b981;
        }
        
        .error-message {
            background: #fee2e2;
            color: #991b1b;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            font-size: 14px;
            border-left: 4px solid #ef4444;
        }
        
        .info-box {
            background: #f0f9ff;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 25px;
            border-left: 4px solid #3b82f6;
        }
        
        .info-box h3 {
            color: #0369a1;
            margin-bottom: 15px;
            font-size: 16px;
        }
        
        .info-box .credential-item {
            background: white;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 8px;
            font-family: monospace;
            display: flex;
            justify-content: space-between;
        }
        
        .credential-item strong {
            color: #1e40af;
        }
        
        .btn-create {
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.2s;
        }
        
        .btn-create:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }
        
        .checklist {
            background: #f9fafb;
            padding: 20px;
            border-radius: 8px;
            margin-top: 25px;
        }
        
        .checklist h4 {
            color: #1f2937;
            margin-bottom: 12px;
            font-size: 14px;
        }
        
        .checklist ul {
            list-style: none;
            padding: 0;
        }
        
        .checklist li {
            padding: 8px 0;
            color: #4b5563;
            font-size: 13px;
        }
        
        .checklist li:before {
            content: "→ ";
            color: #667eea;
            font-weight: bold;
            margin-right: 8px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>👤 Create Admin User</h1>
        <p class="subtitle">Payment Gateway Setup Utility</p>
        
        <div class="warning">
            <strong>⚠️ Security Warning</strong>
            DELETE this file (create-admin.php) immediately after creating the admin user!
        </div>
        
        <?php if ($message): ?>
        <div class="success-message">
            <strong>✓ Success!</strong><br>
            <?php echo htmlspecialchars($message); ?>
            <br><br>
            <strong>You can now login with these credentials:</strong>
            <div style="background: white; padding: 12px; border-radius: 5px; margin-top: 10px; font-family: monospace;">
                <div style="margin-bottom: 5px;">• Username: <strong>Creatorschoice</strong></div>
                <div>• Password: <strong>Creators@7620</strong></div>
            </div>
            <br>
            <strong>Next steps:</strong>
            <ol style="margin-left: 20px; margin-top: 10px;">
                <li>DELETE this file (create-admin.php)</li>
                <li>Go to <a href="admin/login.php" style="color: #065f46;">admin login page</a></li>
                <li>Login with the credentials above</li>
                <li>Change your password in the admin panel</li>
            </ol>
        </div>
        <?php endif; ?>
        
        <?php if ($error): ?>
        <div class="error-message">
            <strong>✗ Error</strong><br>
            <?php echo htmlspecialchars($error); ?>
            <br><br>
            <strong>Troubleshooting:</strong>
            <ul style="margin-left: 20px; margin-top: 10px;">
                <li>Make sure database tables are created (import database.sql)</li>
                <li>Check your database credentials in config.php</li>
                <li>Verify MySQL is running</li>
            </ul>
        </div>
        <?php endif; ?>
        
        <?php if (!$message): ?>
        <div class="info-box">
            <h3>This will create/reset admin user with:</h3>
            <div class="credential-item">
                <span>Username:</span>
                <strong>Creatorschoice</strong>
            </div>
            <div class="credential-item">
                <span>Password:</span>
                <strong>Creators@7620</strong>
            </div>
            <div class="credential-item">
                <span>Role:</span>
                <strong>Super Admin</strong>
            </div>
        </div>
        
        <form method="POST" action="">
            <button type="submit" class="btn-create">
                Create / Reset Admin User
            </button>
        </form>
        
        <div class="checklist">
            <h4>Before running this script, make sure:</h4>
            <ul>
                <li>Database is created</li>
                <li>database.sql has been imported</li>
                <li>config.php has correct database credentials</li>
                <li>MySQL is running and accessible</li>
            </ul>
        </div>
        <?php endif; ?>
    </div>
</body>
</html>
