<?php
/**
 * INSTANT LOGIN FIX
 * 
 * This script will fix your login immediately.
 * Just upload and run this file once.
 */

// Your custom credentials
$username = 'Creatorschoice';
$password = 'Creators@7620';

// Database configuration - EDIT THESE
$db_host = 'localhost';
$db_name = 'payment_gateway';
$db_user = 'root';  // Change this
$db_pass = '';      // Change this

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Instant Login Fix</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .container {
            background: white;
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);
            width: 100%;
            max-width: 600px;
        }
        h1 {
            color: #667eea;
            font-size: 28px;
            margin-bottom: 20px;
            text-align: center;
        }
        .step {
            background: #f9fafb;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 20px;
            border-left: 4px solid #667eea;
        }
        .step h3 {
            color: #667eea;
            margin-bottom: 10px;
        }
        .code {
            background: #1f2937;
            color: #10b981;
            padding: 15px;
            border-radius: 5px;
            font-family: monospace;
            font-size: 12px;
            overflow-x: auto;
            margin: 10px 0;
        }
        .success {
            background: #d1fae5;
            color: #065f46;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            border-left: 4px solid #10b981;
        }
        .error {
            background: #fee2e2;
            color: #991b1b;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            border-left: 4px solid #ef4444;
        }
        .btn {
            display: block;
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            text-align: center;
            text-decoration: none;
            margin-top: 20px;
        }
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }
        .credentials {
            background: white;
            padding: 15px;
            border-radius: 5px;
            margin: 10px 0;
        }
        .warning {
            background: #fef3c7;
            color: #92400e;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            border-left: 4px solid #f59e0b;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔧 Instant Login Fix</h1>

        <?php
        $fixed = false;
        $error_msg = '';

        if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['fix_login'])) {
            try {
                // Connect to database
                $pdo = new PDO(
                    "mysql:host={$db_host};dbname={$db_name};charset=utf8mb4",
                    $db_user,
                    $db_pass,
                    [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
                );

                // Generate correct password hash
                $hashedPassword = password_hash($password, PASSWORD_BCRYPT, ['cost' => 10]);

                // Check if user exists
                $stmt = $pdo->prepare("SELECT id FROM admin_users WHERE username = ?");
                $stmt->execute([$username]);
                $user = $stmt->fetch();

                if ($user) {
                    // Update existing user
                    $stmt = $pdo->prepare("UPDATE admin_users SET password = ?, is_active = 1 WHERE username = ?");
                    $stmt->execute([$hashedPassword, $username]);
                    $fixed = true;
                } else {
                    // Create new user
                    $stmt = $pdo->prepare("
                        INSERT INTO admin_users (username, password, email, full_name, role, is_active) 
                        VALUES (?, ?, 'admin@gateway.local', 'System Administrator', 'super_admin', 1)
                    ");
                    $stmt->execute([$username, $hashedPassword]);
                    $fixed = true;
                }

            } catch (PDOException $e) {
                $error_msg = $e->getMessage();
            }
        }
        ?>

        <?php if ($fixed): ?>
            <div class="success">
                <strong>✅ LOGIN FIXED!</strong><br>
                Your admin account is now ready to use.
            </div>

            <div class="credentials">
                <strong>Your Login Credentials:</strong><br><br>
                <strong>Username:</strong> <?php echo htmlspecialchars($username); ?><br>
                <strong>Password:</strong> <?php echo htmlspecialchars($password); ?>
            </div>

            <a href="admin/login.php" class="btn">Go to Login Page</a>

            <div class="warning" style="margin-top: 20px;">
                <strong>⚠️ IMPORTANT:</strong><br>
                1. Delete this file (fix-login.php) immediately for security!<br>
                2. Login and change your password right away!
            </div>

        <?php elseif ($error_msg): ?>
            <div class="error">
                <strong>❌ Error:</strong><br>
                <?php echo htmlspecialchars($error_msg); ?>
            </div>

            <div class="step">
                <h3>Fix This Error:</h3>
                <p>Edit this file (fix-login.php) at the top and update these lines:</p>
                <div class="code">
$db_host = 'localhost';  // Your database host<br>
$db_name = 'payment_gateway';  // Your database name<br>
$db_user = 'root';  // Your database username<br>
$db_pass = '';  // Your database password
                </div>
                <p style="margin-top: 10px;">Then refresh this page.</p>
            </div>

        <?php else: ?>
            <div class="warning">
                <strong>⚠️ Before you start:</strong><br>
                Make sure you've edited this file with your database credentials at the top of the file.
            </div>

            <div class="step">
                <h3>📋 Step 1: Edit Database Config</h3>
                <p>Open <code>fix-login.php</code> in a text editor and update lines 12-15:</p>
                <div class="code">
$db_host = 'localhost';  // Your MySQL host<br>
$db_name = 'payment_gateway';  // Your database name<br>
$db_user = 'root';  // Your MySQL username<br>
$db_pass = '';  // Your MySQL password
                </div>
            </div>

            <div class="step">
                <h3>🚀 Step 2: Click Button Below</h3>
                <p>This will create/reset your admin account with the correct password.</p>
            </div>

            <div class="credentials">
                <strong>Login credentials that will be set:</strong><br><br>
                <strong>Username:</strong> <?php echo htmlspecialchars($username); ?><br>
                <strong>Password:</strong> <?php echo htmlspecialchars($password); ?>
            </div>

            <form method="POST">
                <button type="submit" name="fix_login" class="btn">
                    🔧 Fix Login Now
                </button>
            </form>

            <div class="step" style="margin-top: 20px;">
                <h3>📝 Current Database Settings:</h3>
                <div class="code">
Host: <?php echo htmlspecialchars($db_host); ?><br>
Database: <?php echo htmlspecialchars($db_name); ?><br>
Username: <?php echo htmlspecialchars($db_user); ?><br>
Password: <?php echo $db_pass ? '********' : '(empty)'; ?>
                </div>
                <p style="margin-top: 10px; font-size: 13px; color: #666;">
                    If these are wrong, edit this file and update the values at the top.
                </p>
            </div>
        <?php endif; ?>

    </div>
</body>
</html>
