<?php
require_once 'config.php';
require_once 'classes/Database.php';
require_once 'classes/Security.php';

$transactionId = $_GET['id'] ?? '';

if (!$transactionId) {
    die('Invalid transaction');
}

$db = Database::getInstance();
$transaction = $db->fetchOne(
    "SELECT transaction_id, amount, currency, status, created_at 
     FROM payment_transactions 
     WHERE transaction_id = ?",
    [$transactionId]
);

if (!$transaction) {
    die('Transaction not found');
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Successful</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .success-container {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            max-width: 500px;
            width: 100%;
            padding: 50px 40px;
            text-align: center;
        }
        
        .success-icon {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, #10b981, #059669);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 30px;
            animation: scaleIn 0.5s ease-out;
        }
        
        .success-icon svg {
            width: 48px;
            height: 48px;
            color: white;
        }
        
        h1 {
            font-size: 32px;
            color: #1f2937;
            margin-bottom: 15px;
        }
        
        .success-message {
            color: #6b7280;
            font-size: 16px;
            margin-bottom: 30px;
            line-height: 1.6;
        }
        
        .transaction-details {
            background: #f9fafb;
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 30px;
            text-align: left;
        }
        
        .detail-row {
            display: flex;
            justify-content: space-between;
            padding: 12px 0;
            border-bottom: 1px solid #e5e7eb;
        }
        
        .detail-row:last-child {
            border-bottom: none;
        }
        
        .detail-label {
            color: #6b7280;
            font-weight: 500;
        }
        
        .detail-value {
            color: #1f2937;
            font-weight: 600;
        }
        
        .transaction-id {
            font-family: monospace;
            font-size: 14px;
        }
        
        .btn-primary {
            display: inline-block;
            padding: 14px 32px;
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
            text-decoration: none;
            border-radius: 8px;
            font-weight: 600;
            transition: transform 0.2s;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 24px rgba(102, 126, 234, 0.4);
        }
        
        .security-note {
            margin-top: 30px;
            padding: 15px;
            background: #f0f9ff;
            border-radius: 8px;
            font-size: 13px;
            color: #0369a1;
        }
        
        @keyframes scaleIn {
            from {
                transform: scale(0);
                opacity: 0;
            }
            to {
                transform: scale(1);
                opacity: 1;
            }
        }
    </style>
</head>
<body>
    <div class="success-container">
        <div class="success-icon">
            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
            </svg>
        </div>
        
        <h1>Payment Successful!</h1>
        <p class="success-message">
            Your payment has been processed successfully. You will receive a confirmation email shortly.
        </p>
        
        <div class="transaction-details">
            <div class="detail-row">
                <span class="detail-label">Amount Paid</span>
                <span class="detail-value">
                    <?php echo Security::escape($transaction['currency']); ?> 
                    <?php echo number_format($transaction['amount'], 2); ?>
                </span>
            </div>
            <div class="detail-row">
                <span class="detail-label">Transaction ID</span>
                <span class="detail-value transaction-id">
                    <?php echo Security::escape($transaction['transaction_id']); ?>
                </span>
            </div>
            <div class="detail-row">
                <span class="detail-label">Date</span>
                <span class="detail-value">
                    <?php echo date('F j, Y \a\t g:i A', strtotime($transaction['created_at'])); ?>
                </span>
            </div>
            <div class="detail-row">
                <span class="detail-label">Status</span>
                <span class="detail-value" style="color: #10b981;">
                    <?php echo ucfirst($transaction['status']); ?>
                </span>
            </div>
        </div>
        
        <div class="security-note">
            🔒 This transaction was processed securely using industry-standard encryption. 
            Keep this transaction ID for your records.
        </div>
    </div>
</body>
</html>
